/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery;

import com.ordana.spelunkery.Spelunkery;
import com.ordana.spelunkery.entities.PrimedMineomiteEntityRenderer;
import com.ordana.spelunkery.items.HandheldCompactorItem;
import com.ordana.spelunkery.items.MagneticCompassItem;
import com.ordana.spelunkery.items.magnetic_compass.MagneticCompassItemPropertyFunction;
import com.ordana.spelunkery.reg.ModBlocks;
import com.ordana.spelunkery.reg.ModEntities;
import com.ordana.spelunkery.reg.ModItems;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class SpelunkeryClient {
    public static final ResourceLocation PARACHUTE_3D_MODEL = Spelunkery.res("entity/parachute");
    private static boolean finishedSetup = false;

    public static void init() {
        ClientPlatformHelper.addEntityRenderersRegistration(SpelunkeryClient::registerEntityRenderers);
        ClientPlatformHelper.addSpecialModelRegistration(SpelunkeryClient::registerSpecialModels);
    }

    public static void setup() {
        ClientPlatformHelper.registerRenderType((Block)((Block)ModBlocks.PORTAL_FLUID.get()), (RenderType)RenderType.m_110466_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.PORTAL_CAULDRON.get(), (RenderType)RenderType.m_110466_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.MINEOMITE.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.SALT_LAMP.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.SALT.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.WOODEN_RAIL.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.ROPE_LADDER.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.TANGLE_ROOTS.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.TANGLE_ROOTS_PLANT.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.SPOROPHYTE.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.TALL_SPOROPHYTE.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.CONK_FUNGUS.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.INKCAP_MUSHROOM.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.WHITE_INKCAP_MUSHROOM.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.PHOSPHOR_FUNGUS.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.MUSHGLOOM.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.MILLY_BUBCAP.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.PORTABELLA.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.CRIMINI.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.BUTTON_MUSHROOM.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.POTTED_INKCAP_MUSHROOM.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.POTTED_WHITE_INKCAP_MUSHROOM.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.POTTED_PHOSPHOR_FUNGUS.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.POTTED_MUSHGLOOM.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.POTTED_MILLY_BUBCAP.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.POTTED_PORTABELLA.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.POTTED_CRIMINI.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.POTTED_BUTTON_MUSHROOM.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.POTTED_SPOROPHYTE.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.NEPHRITE_SPOUT.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerItemProperty((Item)ModItems.DEPTH_GAUGE.get(), (ResourceLocation)Spelunkery.res("depth"), (stack, world, entity, seed) -> entity != null ? ((float)entity.m_146904_() + 64.0f) / 384.0f : 0.0f);
        ClientPlatformHelper.registerItemProperty((Item)ModItems.NEPHRITE_CHARM.get(), (ResourceLocation)Spelunkery.res("charge"), (stack, world, entity, seed) -> stack.m_41783_() != null ? (float)stack.m_41783_().m_128451_("xp") / 1395.0f : 0.0f);
        ClientPlatformHelper.registerItemProperty((Item)ModItems.ITEM_MAGNET.get(), (ResourceLocation)Spelunkery.res("active"), (stack, world, entity, seed) -> stack.m_41783_() != null && stack.m_41783_().m_128471_("active") ? 0.5f : 0.0f);
        ClientPlatformHelper.registerItemProperty((Item)ModItems.HANDHELD_COMPACTOR.get(), (ResourceLocation)Spelunkery.res("mode"), (stack, world, entity, seed) -> stack.m_41783_() != null ? (float)HandheldCompactorItem.getMode(stack).ordinal() / 4.0f : 0.0f);
        ClientPlatformHelper.registerItemProperty((Item)ModItems.MAGNETIC_COMPASS.get(), (ResourceLocation)Spelunkery.res("angle"), (ClampedItemPropertyFunction)new MagneticCompassItemPropertyFunction((clientLevel, itemStack, entity) -> MagneticCompassItem.isMagnetiteNearby(itemStack) ? MagneticCompassItem.getMagnetitePos(itemStack.m_41784_()) : MagneticCompassItem.getNorthPosition((Level)clientLevel)));
        ClientPlatformHelper.registerItemProperty((Item)ModItems.SALT_BUCKET.get(), (ResourceLocation)Spelunkery.res("salt"), (stack, world, entity, seed) -> stack.m_41783_() != null ? (float)stack.m_41783_().m_128451_("salt") / 8.0f : 0.0f);
        ClientPlatformHelper.registerItemProperty((Item)ModItems.PARACHUTE.get(), (ResourceLocation)Spelunkery.res("active"), (stack, world, entity, seed) -> stack.m_41783_() != null ? (stack.m_41783_().m_128471_("active") ? 0.5f : 0.0f) : 0.0f);
        ClientPlatformHelper.registerItemProperty((Item)ModItems.PARACHUTE.get(), (ResourceLocation)Spelunkery.res("used"), (stack, world, entity, seed) -> stack.m_41783_() != null ? (stack.m_41783_().m_128471_("used") ? 0.5f : 0.0f) : 0.0f);
        ClientPlatformHelper.registerItemProperty((Item)ModItems.PARACHUTE.get(), (ResourceLocation)Spelunkery.res("model"), (stack, world, entity, seed) -> stack.m_41783_() != null ? (stack.m_41783_().m_128471_("model") ? 0.5f : 0.0f) : 0.0f);
        finishedSetup = true;
    }

    private static void registerSpecialModels(ClientPlatformHelper.SpecialModelEvent event) {
        event.register(PARACHUTE_3D_MODEL);
    }

    public static void checkIfFailed() {
        if (!finishedSetup) {
            throw new RuntimeException("Failed to run client setup. This is likely due to the mod integration code being outdated, crashing with other mods new versions. Terminating");
        }
    }

    private static void registerEntityRenderers(ClientPlatformHelper.EntityRendererEvent event) {
        event.register(ModEntities.GLOWSTICK.get(), context -> new ThrownItemRenderer(context, 1.0f, false));
        event.register(ModEntities.MINEOMITE.get(), context -> new ThrownItemRenderer(context, 1.0f, false));
        event.register(ModEntities.THROWN_PRIMED_MINEOMITE.get(), context -> new ThrownItemRenderer(context, 1.0f, false));
        event.register(ModEntities.PRIMED_MINEOMITE.get(), PrimedMineomiteEntityRenderer::new);
        event.register(ModEntities.EGGPLANT.get(), context -> new ThrownItemRenderer(context, 1.0f, false));
    }
}

